package cn.lhqs.cubatest.portal.myController;

import cn.lhqs.cubatest.portal.command.PayCompletedEvent;
import cn.lhqs.cubatest.portal.command.PayCompletedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;


@RestController
@RequestMapping("/myapi")
public class SseController {

    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    PayCompletedListener payCompletedListener;

    private Logger log = LoggerFactory.getLogger("SseController.class");

    @GetMapping(value = "/touch")
    public SseEmitter pushh(@RequestParam Long payRecordId){
        final SseEmitter emitter = new SseEmitter();
        try {
            payCompletedListener.addSseEmitters(payRecordId,emitter);
        }catch (Exception e){
            emitter.completeWithError(e);
        }

        return emitter;
    }
    @GetMapping("/callback")
    public String payCallback(@RequestParam Long payRecordId){
        applicationContext.publishEvent(new PayCompletedEvent(this,payRecordId));
        return "callback::end";

    }
}
